/*
 * VMGDataFused.hpp
 *
 *  Created on: Aug 8, 2012
 *      Author: heber
 */

#ifndef VMGDATAFUSED_HPP_
#define VMGDATAFUSED_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/** This namespace contains a key for each data member in MPQCData.
 *
 * We need these keys as enumeration of the data members to allow
 * generic algorithms to work on it.
 *
 * \note forward declarations are not enough as we need the true (but empty)
 * instance when going throughb the list with boost::mpl::for_each.
 */
namespace VMGDataFused {
  // keys for sampled_potential
  struct sampled_potential {};
  struct both_sampled_potential {};
  struct nuclei_long {};
  struct electron_long {};
  // keys for forces
  struct particle_forces {};

  // keys for longrange
  struct electron_longrange {};
  struct electron_shortrange {};
  struct nuclei_longrange {};
  struct nuclei_shortrange {};
  struct mixed_longrange {};
  struct mixed_shortrange {};
  struct total_longrange {};
  struct total_shortrange {};

}



#endif /* VMGDATAFUSED_HPP_ */
