/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ElementsCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "CommandLineUI/CommandLineDialog.hpp"

#include "CommandLineUI/CommandLineParser.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "element.hpp"
#include "periodentafel.hpp"
#include "World.hpp"

CommandLineDialog::ElementsCommandLineQuery::ElementsCommandLineQuery(string title, string _description) :
    Dialog::ElementsQuery(title, _description)
{}

CommandLineDialog::ElementsCommandLineQuery::~ElementsCommandLineQuery()
{}

bool CommandLineDialog::ElementsCommandLineQuery::handle() {
  // TODO: vector of ints and removing first is not correctly implemented yet. How to remove from a vector?
  periodentafel *periode = World::getInstance().getPeriode();
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    vector<int> AllElements = CommandLineParser::getInstance().vm[getTitle()].as< vector<int> >();
    for (vector<int>::iterator ZRunner = AllElements.begin(); ZRunner != AllElements.end(); ++ZRunner) {
      temp = periode->FindElement(*ZRunner);
      ASSERT(temp != NULL, "Invalid element specified in ElementCommandLineQuery");
      tmp.push_back(temp);
    }
    return true;
  } else {
    DoeLog(1) && (eLog() << Verbose(1) << "CommandLineUI parsing error: Missing elements for " << getTitle() << "." << endl);
    return false;
  }
}

