/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2019 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * export_numpy.cpp
 *
 *  Created on: Mar 23, 2019
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include<boost/python/def.hpp>

#include<boost/python/numpy.hpp>

#include "CodePatterns/Assert.hpp"

namespace p = boost::python;
namespace np = boost::python::numpy;

unsigned int get_num_atoms()
{
  return 0;
}

np::ndarray get_positions()
{
  unsigned int num_atoms = get_num_atoms();
  p::tuple shape = p::make_tuple(num_atoms, 3);
  np::dtype dtype = np::dtype::get_builtin<float>();
  np::ndarray positions = np::zeros(shape, dtype);
  return positions;
}

void set_positions(const np::ndarray &new_positions)
{
  unsigned int num_atoms = get_num_atoms();
  
  // check whether shape of array is correct 
  ASSERT( new_positions.shape()[0] == num_atoms,
    "pyMoleCuilder::set_positions() - numpy array has unexpected size.");
}

void export_numpy()
{
  p::def("get_position", get_positions);
  p::def("set_position", set_positions, p::args("position"));
}

