/*
 * AtomIdDescriptor.cpp
 *
 *  Created on: Feb 5, 2010
 *      Author: crueger
 */

#include "AtomIdDescriptor.hpp"
#include "AtomIdDescriptor_impl.hpp"

#include "atom.hpp"

using namespace std;


AtomIdDescriptor_impl::AtomIdDescriptor_impl(int _id) :
  id(_id)
{}

AtomIdDescriptor_impl::~AtomIdDescriptor_impl()
{}

bool AtomIdDescriptor_impl::predicate(std::pair<int,atom*> atom) {
  return atom.second->getId()==id;
}

AtomDescriptor AtomById(int id){
  return AtomDescriptor(AtomDescriptor::impl_ptr(new AtomIdDescriptor_impl(id)));
}

#if 0

// so far the lookuptable for Atoms-by-id does not work, since atoms don't get an ID upon creation.
// instead of this we rely on walking through all atoms.

atom *AtomIdDescriptor::find(){
  map<int,atom*> atoms = getAtoms();
  map<int,atom*>::iterator res = atoms.find(id);
  return (res!=atoms.end())?((*res).second):0;
}

vector<atom*> AtomIdDescriptor::findAll(){
  atom *res = find();
  return (res)?(vector<atom*>(1,res)):(vector<atom*>());
}

#endif
