/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * MoleculeNameDescriptor.cpp
 *
 *  Created on: Jun 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "MoleculeNameDescriptor.hpp"
#include "MoleculeNameDescriptor_impl.hpp"

#include "molecule.hpp"

using namespace std;


MoleculeNameDescriptor_impl::MoleculeNameDescriptor_impl(std::string _name) :
  name(_name)
{}

MoleculeNameDescriptor_impl::~MoleculeNameDescriptor_impl()
{}

bool MoleculeNameDescriptor_impl::predicate(const std::pair<moleculeId_t,const molecule*> molecule)  const{
  return molecule.second->name==name;
}

MoleculeDescriptor MoleculeByName(std::string name){
  return MoleculeDescriptor(MoleculeDescriptor::impl_ptr(new MoleculeNameDescriptor_impl(name)));
}
