/*
 * LinePoint.hpp
 *
 *  Created on: Jan 28, 2012
 *      Author: crueger
 */

#ifndef LINEPOINT_HPP_
#define LINEPOINT_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <iosfwd>
#include <memory>
#include <vector>

#include "Line.hpp"

class Vector;

/**
 * Class for representing points on a line
 *
 * These objects allow comparison of points on the same line as well as
 * specifying the infinite "endpoints" of a line.
 *
 * Note that LinePoint::param is not in [0,1] but has any real value relative
 * to the Line::origin and Line::destination of a which a point it is.
 */
class LinePoint{
  friend class Line;
  friend bool operator==(const LinePoint&, const LinePoint&);
  friend bool operator<(const LinePoint&, const LinePoint&);
public:
  LinePoint(const LinePoint&);
  LinePoint& operator=(const LinePoint&);
  Vector getPoint() const;
  Line getLine() const;
  bool isInfinite() const;
  bool isPosInfinity() const;
  bool isNegInfinity() const;

private:
  LinePoint(const Line&,double);
  Line line;
  double param;
};

bool operator==(const LinePoint&, const LinePoint&);
bool operator<(const LinePoint&, const LinePoint&);

inline bool operator!= (const LinePoint& x, const LinePoint& y) { return !(x==y); }
inline bool operator>  (const LinePoint& x, const LinePoint& y) { return y<x; }
inline bool operator<= (const LinePoint& x, const LinePoint& y) { return !(y<x); }
inline bool operator>= (const LinePoint& x, const LinePoint& y) { return !(x<y); }


#endif /* LINEPOINT_HPP_ */
