/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * LinePoint.cpp
 *
 *  Created on: Jan 28, 2012
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "LinePoint.hpp"

#include <limits>

#include "CodePatterns/Assert.hpp"
#include "defs.hpp"
#include "Line.hpp"
#include "Vector.hpp"

LinePoint::LinePoint(const LinePoint &src) :
  line(src.line),param(src.param)
{}

LinePoint::LinePoint(const Line &_line, double _param) :
  line(_line),param(_param)
{}

LinePoint& LinePoint::operator=(const LinePoint &src){
  line=src.line;
  param=src.param;
  return *this;
}

Vector LinePoint::getPoint() const{
  ASSERT(!isInfinite(),"getPoint() on infinite LinePoint called");
  return (*line.origin)+param*(*line.direction);
}

Line LinePoint::getLine() const{
  return line;
}

bool LinePoint::isInfinite() const{
  return isPosInfinity() || isNegInfinity();
}
bool LinePoint::isPosInfinity() const{
  return param == std::numeric_limits<double>::infinity();
}
bool LinePoint::isNegInfinity() const{
  return param == -std::numeric_limits<double>::infinity();
}

bool operator==(const LinePoint &x, const LinePoint &y){
  ASSERT(x.line==y.line,"Operation on two points of different lines");
  return x.param == y.param;

}
bool operator<(const LinePoint &x, const LinePoint &y){
  ASSERT(x.line==y.line,"Operation on two points of different lines");
  return x.param<y.param;
}

