/*
 * Line.hpp
 *
 *  Created on: Apr 30, 2010
 *      Author: crueger
 */

#ifndef LINE_HPP_
#define LINE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "Space.hpp"

#include <iosfwd>
#include <memory>
#include <vector>

class Vector;
class Plane;
class LinePoint;

/** This class represents a line in space stretching to infinity.
 *
 * It is defined by its origin and a direction.
 *
 * \sa LinePoint and LineSegment
 */
class Line : public Space
{
  friend bool operator==(const Line&,const Line&);
  friend class LinePoint;
public:
  Line(const Vector &_origin, const Vector &_direction);
  Line(const Line& _src);
  virtual ~Line();

  Line &operator=(const Line& rhs);

  virtual double distance(const Vector &point) const;
  virtual Vector getClosestPoint(const Vector &point) const;

  Vector getDirection() const;
  Vector getOrigin() const;

  std::vector<Vector> getPointsOnLine() const;

  Vector getIntersection(const Line& otherLine) const;

  Vector rotateVector(const Vector &rhs, double alpha) const;
  Line rotateLine(const Line &rhs, double alpha) const;
  Plane rotatePlane(const Plane &rhs, double alpha) const;

  Plane getOrthogonalPlane(const Vector &origin) const;

  std::vector<Vector> getSphereIntersections() const;

  LinePoint getLinePoint(const Vector&) const;
  LinePoint posEndpoint() const;
  LinePoint negEndpoint() const;



private:
  std::auto_ptr<Vector> origin;
  std::auto_ptr<Vector> direction;
};

bool operator==(const Line&,const Line&);

std::ostream & operator << (std::ostream& ost, const Line &m);

/**
 * Named constructor to make a line through two points
 */
Line makeLineThrough(const Vector &x1, const Vector &x2);

#endif /* LINE_HPP_ */
