/*
 * CommandLineDialog.hpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#ifndef COMMANDLINEDIALOG_HPP_
#define COMMANDLINEDIALOG_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <string>

class atom;
class element;
class molecule;
class Vector;

#include "Dialog.hpp"

/** CommandLineUIFactory implementation of the Dialog.
 * The idea here is that for each query the parsed command line options are used instead.
 */
class CommandLineDialog : public Dialog
{
public:
  CommandLineDialog();
  virtual ~CommandLineDialog();

  virtual void queryEmpty(const char *, std::string = "");
  virtual void queryInt(Parameter<int> &, const char *, std::string = "");
  virtual void queryInts(Parameter<std::vector<int> > &, const char *, std::string = "");
  virtual void queryUnsignedInt(Parameter<unsigned int> &, const char *, std::string = "");
  virtual void queryUnsignedInts(Parameter<std::vector<unsigned int> > &, const char *, std::string = "");
  virtual void queryBoolean(Parameter<bool> &, const char *, std::string = "");
  virtual void queryString(Parameter<std::string> &, const char*, std::string = "");
  virtual void queryStrings(Parameter<std::vector<std::string> > &, const char*, std::string = "");
  virtual void queryDouble(Parameter<double> &, const char*, std::string = "");
  virtual void queryDoubles(Parameter<std::vector<double> > &, const char*, std::string = "");
  virtual void queryAtom(Parameter<const atom *> &, const char*, std::string = "");
  virtual void queryAtoms(Parameter<std::vector<const atom *> > &, const char*, std::string = "");
  virtual void queryMolecule(Parameter<const molecule *> &, const char*, std::string = "");
  virtual void queryMolecules(Parameter<std::vector<const molecule *> > &, const char*, std::string = "");
  virtual void queryVector(Parameter<Vector> &, const char*, bool, std::string = "");
  virtual void queryVectors(Parameter<std::vector<Vector> > &, const char*, bool, std::string = "");
  virtual void queryRealSpaceMatrix(Parameter<RealSpaceMatrix> &, const char*, std::string = "");
  virtual void queryElement(Parameter<const element *> &, const char*, std::string = "");
  virtual void queryElements(Parameter<std::vector<const element *> > &, const char*, std::string = "");
  virtual void queryFile(Parameter<boost::filesystem::path> &, const char*, std::string = "");
  virtual void queryFiles(Parameter<std::vector< boost::filesystem::path> > &, const char*, std::string = "");
  virtual void queryRandomNumberDistribution_Parameters(Parameter<RandomNumberDistribution_Parameters> &, const char*, std::string = "");
  // specialized stuff for command line queries
  // all placed into Query/CommandLineQuery.hpp
  // !please adhere to alphabetical ordering!
  class AtomCommandLineQuery;
  class AtomsCommandLineQuery;
  class BooleanCommandLineQuery;
  class DoubleCommandLineQuery;
  class DoublesCommandLineQuery;
  class ElementCommandLineQuery;
  class ElementsCommandLineQuery;
  class EmptyCommandLineQuery;
  class FileCommandLineQuery;
  class FilesCommandLineQuery;
  class IntCommandLineQuery;
  class IntsCommandLineQuery;
  class MoleculeCommandLineQuery;
  class MoleculesCommandLineQuery;
  class RealSpaceMatrixCommandLineQuery;
  class StringCommandLineQuery;
  class StringsCommandLineQuery;
  class UnsignedIntCommandLineQuery;
  class UnsignedIntsCommandLineQuery;
  class VectorCommandLineQuery;
  class VectorsCommandLineQuery;
  class RandomNumberDistribution_ParametersCommandLineQuery;
};

#endif /* COMMANDLINEDIALOG_HPP_ */
