/*
 * controller_SystemCommandJob.hpp
 *
 *  Created on: 01.06.2012
 *      Author: heber
 */

#ifndef CONTROLLER_SYSTEMCOMMANDJOB_HPP_
#define CONTROLLER_SYSTEMCOMMANDJOB_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/function.hpp>
#include <boost/program_options.hpp>

#include "controller_AddOn.hpp"

class ControllerCommand;
class ControllerCommandRegistry;
class ControllerInfo;
class ControllerOptions;
class FragmentController;

struct controller_SystemCommandJob : public controller_AddOn
{
  ControllerOptions *allocateControllerInfo();

  void addSpecificCommands(
      boost::function<void (ControllerCommand *)> &registrator,
      FragmentController &controller,
      ControllerOptions &ControllerInfo);

  void addSpecificOptions(
      boost::program_options::options_description_easy_init option);

  int addOtherParsings(
      ControllerOptions &ControllerInfo,
      boost::program_options::variables_map &vm);
};

#endif /* CONTROLLER_SYSTEMCOMMANDJOB_HPP_ */
