/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * StringsCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

CommandLineDialog::StringsCommandLineQuery::StringsCommandLineQuery(string title, string _description) :
    Dialog::StringsQuery(title, _description)
{}

CommandLineDialog::StringsCommandLineQuery::~StringsCommandLineQuery() {}

bool CommandLineDialog::StringsCommandLineQuery::handle() {
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    tmp = CommandLineParser::getInstance().vm[getTitle()].as< std::vector<std::string> >();
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing strings for " << getTitle() << ".");
    return false;
  }
}

