/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VectorTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"
#include "World.hpp"


TextDialog::VectorTextQuery::VectorTextQuery(std::string title, bool _check, std::string _description) :
    Dialog::VectorQuery(title,_check,_description)
{}

TextDialog::VectorTextQuery::~VectorTextQuery()
{}

bool TextDialog::VectorTextQuery::handle() {
  std::cout << getDescription() << std::endl;
  const RealSpaceMatrix &M = World::getInstance().getDomain().getM();
  char coords[3] = {'x', 'y', 'z'};
  for (int i=0;i<3;i++)
    std::cout << coords[i] << "[0.." << M.at(i,i) << ( (i!=2) ? "], " : "]: ");

  std::string line;
  getline(std::cin,line);

  // dissect by ","
  double coord = 0.;
  int counter = 0;
  std::string::iterator olditer = line.begin();
  for(string::iterator iter = line.begin(); (iter != line.end()) && (counter != 3); ++iter) {
    if (*iter == ',') {
      std::istringstream stream(string(iter, olditer));
      stream >> coord;
      tmp[counter++] = coord;
      olditer = iter;
    }
  }
  if ((olditer != line.begin()) && (counter != 3)) { // insert last part also
    std::istringstream stream(string(olditer, line.end()));
    stream >> coord;
    tmp[counter++] = coord;
  }

  // check vector
  return World::getInstance().getDomain().isValid(tmp);
}

