/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ActionRegistryUnitTest.cpp
 *
 *  Created on: Dec 15, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "ActionRegistryUnitTest.hpp"

#include <typeinfo>

#include "Actions/ActionRegistry.hpp"
#include "Actions/ActionTrait.hpp"
#include "Actions/OptionRegistry.hpp"
#include "Actions/OptionTrait.hpp"

using namespace MoleCuilder;

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ActionRegistryTest );


void ActionRegistryTest::setUp()
{};


void ActionRegistryTest::tearDown()
{};

void ActionRegistryTest::CheckDoublyUsedShortforms()
{
  std::map <std::string, std::string> result;

  ActionRegistry &AR = ActionRegistry::getInstance();
  for (ActionRegistry::const_iterator iter = AR.getBeginIter(); iter != AR.getEndIter(); ++iter) {
    if ((iter->second)->Traits.hasShortForm()) {
      ASSERT(result.find((iter->second)->Traits.getShortForm()) == result.end(),
          "Short form "+toString((iter->second)->Traits.getShortForm())+
          " for action "+toString(iter->first)+" already present from "+
          std::string(result[(iter->second)->Traits.getShortForm()])+"!");
      result[(iter->second)->Traits.getShortForm()] = (iter->second)->getName();
    }
  }
}
