/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * TimeStepPresentValidator.cpp
 *
 *  Created on: May 10, 2012
 *      Author: ankele
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "TimeStepPresentValidator.hpp"

#include "WorldTime.hpp"
#include "World.hpp"

bool TimeStepPresentValidator::isValid(const unsigned int & _value) const
{
  size_t maxTime = 0;
  std::vector<atom*> AllAtoms = World::getInstance().getAllAtoms();
  for(std::vector<atom*>::iterator AtomRunner = AllAtoms.begin(); AtomRunner != AllAtoms.end(); ++AtomRunner) {
    int size = (dynamic_cast<AtomInfo *>(*AtomRunner))->getTrajectorySize();
    if (size > maxTime)
      maxTime = size;
  }

  return (_value <= maxTime);
}

bool TimeStepPresentValidator::operator==(const Validator<unsigned int> &_instance) const
{
  const TimeStepPresentValidator *inst =
      dynamic_cast<const TimeStepPresentValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< unsigned int >* TimeStepPresentValidator::clone() const
{
  Validator< unsigned int > *inst =
      new TimeStepPresentValidator();
  return inst;
}




