/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * CommandLineUIFactory.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "CommandLineUI/CommandLineUIFactory.hpp"
#include "CommandLineUI/CommandLineWindow.hpp"
#include "CommandLineUI/CommandLineDialog.hpp"


CommandLineUIFactory::CommandLineUIFactory()
{
  // TODO Auto-generated constructor stub

}

CommandLineUIFactory::~CommandLineUIFactory()
{
  // TODO Auto-generated destructor stub
}


Dialog* CommandLineUIFactory::makeDialog(const std::string &_title) {
  return new CommandLineDialog(_title);
}

MainWindow* CommandLineUIFactory::makeMainWindow() {
  MainWindow* const mainwindow = new CommandLineWindow();
  UIFactory::doneInitializing = true;
  return mainwindow;
}

CommandLineUIFactory::description::description() :
    UIFactory::factoryDescription("CommandLine")
{}

CommandLineUIFactory::description::~description()
{}

UIFactory* CommandLineUIFactory::description::makeFactory(){
  return new CommandLineUIFactory();
}
