/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * IntsCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"

CommandLineDialog::IntsCommandLineQuery::IntsCommandLineQuery(string title, string _description) :
    Dialog::IntsQuery(title, _description)
{}

CommandLineDialog::IntsCommandLineQuery::~IntsCommandLineQuery() {}

bool CommandLineDialog::IntsCommandLineQuery::handle() {
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    tmp = CommandLineParser::getInstance().vm[getTitle()].as< std::vector<int> >();
    return true;
  } else {
    DoeLog(1) && (eLog() << Verbose(1) << "CommandLineUI parsing error: Missing integers for " << getTitle() << "." << endl);
    return false;
  }
}

