/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * MoleculeFormulaDescriptor.cpp
 *
 *  Created on: Jul 22, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "MoleculeFormulaDescriptor.hpp"
#include "MoleculeFormulaDescriptor_impl.hpp"

#include "Formula.hpp"
#include "molecule.hpp"


MoleculeFormulaDescriptor_impl::MoleculeFormulaDescriptor_impl(const Formula &_formula) :
  formula(_formula)
{}

MoleculeFormulaDescriptor_impl::~MoleculeFormulaDescriptor_impl(){}

bool MoleculeFormulaDescriptor_impl::predicate(std::pair<moleculeId_t,molecule*> molecule){
  return molecule.second->getFormula() == formula;
}


MoleculeDescriptor MoleculeByFormula(const Formula &formula)
{
  return MoleculeDescriptor(MoleculeDescriptor::impl_ptr(new MoleculeFormulaDescriptor_impl(formula)));
}

MoleculeDescriptor MoleculeByFormula(const std::string &_formula) throw(FormulaStringParseException){
  Formula formula(_formula);
  return MoleculeByFormula(formula);
}
