/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * PointCorrelationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Analysis/analysis_correlation.hpp"
#include "CodePatterns/Verbose.hpp"
#include "CodePatterns/Log.hpp"
#include "Element/element.hpp"
#include "Element/periodentafel.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <cmath>
#include <iostream>
#include <string>

#include "Actions/AnalysisAction/PointCorrelationAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "PointCorrelationAction.def"
#include "Action_impl_pre.hpp"

/** =========== define the function ====================== */
Action::state_ptr AnalysisPointCorrelationAction::performCall() {
  int ranges[3] = {1, 1, 1};
  ofstream output;
  ofstream binoutput;
  string type;
  BinPairMap *binmap = NULL;

  // execute action
  output.open(params.outputname.get().string().c_str());
  binoutput.open(params.binoutputname.get().string().c_str());
  cout << "Point to correlate to is  " << params.Point.get() << endl;
  CorrelationToPointMap *correlationmap = NULL;
  for(std::vector<const element *>::const_iterator iter = params.elements.get().begin(); iter != params.elements.get().end(); ++iter)
    cout << "element is " << (*iter)->getSymbol() << endl;
  std::vector<molecule*> molecules = World::getInstance().getSelectedMolecules();
  if (params.periodic.get())
    correlationmap  = PeriodicCorrelationToPoint(molecules, params.elements.get(), &params.Point.get(), ranges);
  else
    correlationmap = CorrelationToPoint(molecules, params.elements.get(), &params.Point.get());
  OutputCorrelationMap<CorrelationToPointMap>(&output, correlationmap, OutputCorrelationToPoint_Header, OutputCorrelationToPoint_Value);
  binmap = BinData( correlationmap, params.BinWidth.get(), params.BinStart.get(), params.BinEnd.get() );
  OutputCorrelationMap<BinPairMap> ( &binoutput, binmap, OutputCorrelation_Header, OutputCorrelation_Value );
  delete(binmap);
  delete(correlationmap);
  output.close();
  binoutput.close();
  return Action::success;
}

Action::state_ptr AnalysisPointCorrelationAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr AnalysisPointCorrelationAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool AnalysisPointCorrelationAction::canUndo() {
  return true;
}

bool AnalysisPointCorrelationAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
