/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * IsValidInDomain_FillPredicate.cpp
 *
 *  Created on: Jan 16, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include <boost/bind.hpp>

#include "IsValidInDomain_FillPredicate.hpp"

#include "AnyFillPredicate.hpp"
#include "Box.hpp"
#include "FillPredicate.hpp"


FillPredicate IsValidInDomain_FillPredicate(const Box &domain)
{
  AnyFillPredicate::FillPredicator function = boost::bind(&Box::isValid, &domain, _1);
  FillPredicate::impl_ptr impl(new AnyFillPredicate(function));
  return FillPredicate(impl);
}
