/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * BoxTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"


TextDialog::RealSpaceMatrixTextQuery::RealSpaceMatrixTextQuery(Parameter<RealSpaceMatrix> &_param, const std::string &_title, const std::string &_description) :
    Dialog::TQuery<RealSpaceMatrix>(_param, _title,_description)
{}

TextDialog::RealSpaceMatrixTextQuery::~RealSpaceMatrixTextQuery()
{}

bool TextDialog::RealSpaceMatrixTextQuery::handle() {
  std::cout << getTitle();

  double dtemp[6];
  std::cout << getDescription() << " - ";
  std::string coords[6] = {"xx","yx","yy", "zx", "zy", "zz"};
  for (int i=0;i<6;i++) {
    std::cout << coords[i] << ": ";
    std::cin >> dtemp[i];
  }
  temp.set(0,0, dtemp[0]);
  temp.set(0,1, dtemp[1]);
  temp.set(0,2, dtemp[2]);
  temp.set(1,0, dtemp[1]);
  temp.set(1,1, dtemp[3]);
  temp.set(1,2, dtemp[4]);
  temp.set(2,0, dtemp[2]);
  temp.set(2,1, dtemp[4]);
  temp.set(2,2, dtemp[5]);
  return true;
}

