/*
 * TextDialog.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#include <iostream>

#include "UIElements/TextDialog.hpp"

#include "atom.hpp"
#include "molecule.hpp"
#include "log.hpp"
#include "verbose.hpp"

using namespace std;


TextDialog::TextDialog()
{
}

TextDialog::~TextDialog()
{
}


void TextDialog::queryInt(const char* title, int* target){
  registerQuery(new IntTextQuery(title,target));
}

void TextDialog::queryDouble(const char* title, double* target){
  registerQuery(new DoubleTextQuery(title,target));
}

void TextDialog::queryString(const char* title, string* target){
  registerQuery(new StringTextQuery(title,target));
}

void TextDialog::queryMolecule(const char* title, molecule **target, MoleculeListClass *molecules) {
  registerQuery(new MoleculeTextQuery(title,target,molecules));
}

void TextDialog::queryVector(const char* title, Vector *target,const double *const cellSize, bool check) {
  registerQuery(new VectorTextQuery(title,target,cellSize,check));
}

/************************** Query Infrastructure ************************/

TextDialog::IntTextQuery::IntTextQuery(string title,int *_target) :
    Dialog::IntQuery(title,_target)
{}

TextDialog::IntTextQuery::~IntTextQuery() {}

bool TextDialog::IntTextQuery::handle() {
  Log() << Verbose(0) << getTitle();
  cin >> tmp;
  return true;
}

TextDialog::StringTextQuery::StringTextQuery(string title,string *_target) :
    Dialog::StringQuery(title,_target)
{}

TextDialog::StringTextQuery::~StringTextQuery() {}

bool TextDialog::StringTextQuery::handle() {
  //Log() << Verbose(0) << getTitle();
  cin >> tmp;
  return true;
}

TextDialog::DoubleTextQuery::DoubleTextQuery(string title,double *_target) :
    Dialog::DoubleQuery(title,_target)
{}

TextDialog::DoubleTextQuery::~DoubleTextQuery() {}

bool TextDialog::DoubleTextQuery::handle() {
  Log() << Verbose(0) << getTitle();
  cin >> tmp;
  return true;
}

TextDialog::MoleculeTextQuery::MoleculeTextQuery(string title, molecule **_target, MoleculeListClass *_molecules) :
    Dialog::MoleculeQuery(title,_target,_molecules)
{}

TextDialog::MoleculeTextQuery::~MoleculeTextQuery() {}

bool TextDialog::MoleculeTextQuery::handle() {
  int idxOfMol;
  Log() << Verbose(0) << getTitle();
  cin >> idxOfMol;
  tmp = molecules->ReturnIndex(idxOfMol);
  while(!tmp && (idxOfMol !=-1)) {
    Log() << Verbose(0) << "Invalid Molecule Index" << endl;
    Log() << Verbose(0) << getTitle();
    cin >> idxOfMol;
    tmp = molecules->ReturnIndex(idxOfMol);
  }
  return (idxOfMol!=-1);
}

TextDialog::VectorTextQuery::VectorTextQuery(std::string title, Vector *_target, const double *const _cellSize, bool _check) :
    Dialog::VectorQuery(title,_target,_cellSize,_check)
{}

TextDialog::VectorTextQuery::~VectorTextQuery()
{}

bool TextDialog::VectorTextQuery::handle() {
 tmp->AskPosition(cellSize,check);
 return true;
}
