#include "Actions/small_actions.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"

#include "atom.hpp"
#include "molecule.hpp"

/****** ChangeMoleculeNameAction *****/

// memento to remember the state when undoing

class ChangeMoleculeNameState : public ActionState {
public:
  ChangeMoleculeNameState(molecule* _mol,std::string _lastName) :
    mol(_mol),
    lastName(_lastName)
  {}
  molecule* mol;
  std::string lastName;
};

char ChangeMoleculeNameAction::NAME[] = "Change filename of Molecule";

ChangeMoleculeNameAction::ChangeMoleculeNameAction(MoleculeListClass *_molecules) :
  Action(NAME),
  molecules(_molecules)
{}

ChangeMoleculeNameAction::~ChangeMoleculeNameAction()
{}

Action::state_ptr ChangeMoleculeNameAction::performCall() {
  string filename;
  molecule *mol = NULL;
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryMolecule("Enter index of molecule: ",&mol,molecules);
  dialog->queryString("Enter name: ",&filename);

  if(dialog->display()) {
    string oldName = mol->getName();
    mol->setName(filename);
    delete dialog;
    return Action::state_ptr(new ChangeMoleculeNameState(mol,oldName));
  }
  delete dialog;
  return Action::failure;
}

Action::state_ptr ChangeMoleculeNameAction::performUndo(Action::state_ptr _state) {
  ChangeMoleculeNameState *state = dynamic_cast<ChangeMoleculeNameState*>(_state.get());
  ASSERT(state,"State passed to ChangeMoleculeNameAction::performUndo did not have correct type");

  string newName = state->mol->getName();
  state->mol->setName(state->lastName);

  return Action::state_ptr(new ChangeMoleculeNameState(state->mol,newName));
}

Action::state_ptr ChangeMoleculeNameAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool ChangeMoleculeNameAction::canUndo() {
  return true;
}

bool ChangeMoleculeNameAction::shouldUndo() {
  return true;
}

const string ChangeMoleculeNameAction::getName() {
  return NAME;
}
