/*
 * ManipulateAtomsProcess.hpp
 *
 *  Created on: Feb 18, 2010
 *      Author: crueger
 */

#ifndef MANIPULATEATOMSPROCESS_HPP_
#define MANIPULATEATOMSPROCESS_HPP_

#include "Actions/Process.hpp"

#include<boost/function.hpp>

#include "Descriptors/AtomDescriptor.hpp"

class World;

class ManipulateAtomsProcess : public Process
{
public:
  ManipulateAtomsProcess(boost::function<void(atom*)> _operation, AtomDescriptor descr,std::string _name,bool _doRegister=true);
  virtual ~ManipulateAtomsProcess();

  virtual bool canUndo();
  virtual bool shouldUndo();

  virtual void doManipulate(World *);
private:

  virtual Action::state_ptr performCall();
  virtual Action::state_ptr performUndo(Action::state_ptr);
  virtual Action::state_ptr performRedo(Action::state_ptr);

  AtomDescriptor descr;
  boost::function<void(atom*)> operation;
};

#endif /* MANIPULATEATOMSPROCESS_HPP_ */
