/*
 * Action.cpp
 *
 *  Created on: Dec 8, 2009
 *      Author: crueger
 */

#include <string>

#include "Actions/Action.hpp"
#include "Actions/ActionRegistry.hpp"

using namespace std;

// An empty state to indicate success
Action::state_ptr Action::success = Action::state_ptr(new ActionState());
Action::state_ptr Action::failure = Action::state_ptr(new ActionState());

Action::Action(std::string _name,bool _doRegister) :
name(_name)
{
  if(_doRegister){
    ActionRegistry::getInstance().registerAction(this);
  }
}

Action::~Action()
{}

const string Action::getName(){
  return name;
}

void Action::call(){
  // forward to private virtual
  performCall();
}
Action::state_ptr Action::undo(state_ptr _state) {
  // forward to private virtual
  return performUndo(_state);
}
Action::state_ptr Action::redo(state_ptr _state) {
  // forward to private virtual
  return performRedo(_state);
}
