/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * VectorTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"
#include "World.hpp"


TextDialog::VectorTextQuery::VectorTextQuery(Parameter<Vector> &_param, const std::string &_title, const std::string &_description) :
    Dialog::TQuery<Vector>(_param, _title,_description)
{}

TextDialog::VectorTextQuery::~VectorTextQuery()
{}

bool TextDialog::VectorTextQuery::handle() {
  std::cout << getDescription() << std::endl;
  const RealSpaceMatrix &M = World::getInstance().getDomain().getM();
  char coords[3] = {'x', 'y', 'z'};
  for (int i=0;i<3;i++)
    std::cout << coords[i] << "[0.." << M.at(i,i) << ( (i!=2) ? "], " : "]: ");

  std::string line;
  getline(std::cin,line);

  // dissect by ","
  double coord = 0.;
  int counter = 0;
  std::string::iterator olditer = line.begin();
  for(std::string::iterator iter = line.begin(); (iter != line.end()) && (counter != 3); ++iter) {
    if (*iter == ',') {
      iter++;
      std::istringstream stream(std::string(olditer, iter));
      stream >> coord;
      temp[counter++] = coord;
      olditer = iter;
    }
  }
  if ((olditer != line.begin()) && (counter != 3)) { // insert last part also
    std::istringstream stream(std::string(olditer, line.end()));
    stream >> coord;
    temp[counter++] = coord;
  }

  // check vector
  return World::getInstance().getDomain().isValid(temp);
}

