/*
 * VectorContent.hpp
 *
 *  Created on: Jul 2, 2010
 *      Author: crueger
 */

#ifndef VECTORCONTENT_HPP_
#define VECTORCONTENT_HPP_

/**
 * !file
 * The way GSL works does not allow for forward definitions of the structures.
 * Because of this the pointer to the gsl_vector struct is wrapped inside another
 * (dumb) object that allows for forward definitions.
 */

#include <gsl/gsl_vector.h>

struct BaseCase{};

struct VectorContent{
  VectorContent(){
    content =  gsl_vector_calloc (NDIM);
  }
  VectorContent(BaseCase){

  }
  virtual ~VectorContent(){
    if(content){
      gsl_vector_free(content);
      content = 0;
    }
  }
  gsl_vector *content;
};

struct VectorViewContent : public VectorContent{
  VectorViewContent(gsl_vector_view _view) :
    VectorContent(BaseCase()),
    view(_view)
  {
    content=&view.vector;
  }
  virtual ~VectorViewContent(){
    content=0;
  }
  gsl_vector_view view;
};

#endif /* VECTORCONTENT_HPP_ */
