/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FastParsingAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Actions/CommandAction/FastParsingAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "config.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

// memento to remember the state when undoing

class CommandFastParsingState : public ActionState {
public:
  CommandFastParsingState(const bool _oldvalue, const bool _newvalue) :
    oldvalue(_oldvalue),
    newvalue(_newvalue)
  {}
  bool oldvalue;
  bool newvalue;
};


const char CommandFastParsingAction::NAME[] = "fastparsing";

CommandFastParsingAction::CommandFastParsingAction() :
  Action(NAME)
{}

CommandFastParsingAction::~CommandFastParsingAction()
{}

void CommandFastParsing(bool fastparsing) {
  ValueStorage::getInstance().setCurrentValue(CommandFastParsingAction::NAME, fastparsing);
  ActionRegistry::getInstance().getActionByName(CommandFastParsingAction::NAME)->call(Action::NonInteractive);
};

void CommandFastParsingAction::getParametersfromValueStorage()
{};

Dialog* CommandFastParsingAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryBoolean(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr CommandFastParsingAction::performCall() {
  config *configuration = World::getInstance().getConfig();
  bool oldvalue = configuration->FastParsing;
  bool newvalue;
  ValueStorage::getInstance().queryCurrentValue(NAME, newvalue);
  configuration->FastParsing = newvalue;
  if (configuration->FastParsing)
    DoLog(0) && (Log() << Verbose(0) << "I won't parse trajectories." << endl);
  else
    DoLog(0) && (Log() << Verbose(0) << "I will parse trajectories." << endl);
  return Action::state_ptr(new CommandFastParsingState(oldvalue, newvalue));
}

Action::state_ptr CommandFastParsingAction::performUndo(Action::state_ptr _state) {
  CommandFastParsingState *state = assert_cast<CommandFastParsingState*>(_state.get());

  config *configuration = World::getInstance().getConfig();
  configuration->FastParsing = state->oldvalue;
  if (configuration->FastParsing)
    DoLog(0) && (Log() << Verbose(0) << "I won't parse trajectories." << endl);
  else
    DoLog(0) && (Log() << Verbose(0) << "I will parse trajectories." << endl);

  return Action::state_ptr(_state);
}

Action::state_ptr CommandFastParsingAction::performRedo(Action::state_ptr _state){
  CommandFastParsingState *state = assert_cast<CommandFastParsingState*>(_state.get());

  config *configuration = World::getInstance().getConfig();
  configuration->FastParsing = state->newvalue;
  if (configuration->FastParsing)
    DoLog(0) && (Log() << Verbose(0) << "I won't parse trajectories." << endl);
  else
    DoLog(0) && (Log() << Verbose(0) << "I will parse trajectories." << endl);

  return Action::state_ptr(_state);
}

bool CommandFastParsingAction::canUndo() {
  return true;
}

bool CommandFastParsingAction::shouldUndo() {
  return true;
}

const string CommandFastParsingAction::getName() {
  return NAME;
}
