/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SetRandomNumbersEngine.cpp
 *
 *  Created on: Jan 01, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "molecule.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include "RandomNumbers/RandomNumberEngine.hpp"
#include "RandomNumbers/RandomNumberEngine_Parameters.hpp"
#include "RandomNumbers/RandomNumberEngineFactory.hpp"

#include <iostream>
#include <sstream>
#include <string>

using namespace std;

#include "SetRandomNumbersEngineAction.hpp"

// and construct the stuff
#include "SetRandomNumbersEngineAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr CommandSetRandomNumbersEngineAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  // note down old type
  std::string oldtype = RandomNumberEngineFactory::getInstance().getCurrentTypeName();
  DoLog(1) && (Log() << Verbose(1) << "Current engine is " << oldtype << std::endl);

  // set the new default
  RandomNumberEngineFactory::getInstance().setCurrentType(params.engine_type);
  DoLog(0) && (Log() << Verbose(0) << "Engine of random number generator is now: "
      << RandomNumberEngineFactory::getInstance().getCurrentTypeName() << std::endl);

  // note down old parameters
  RandomNumberEngine_Parameters *oldparameters =
      RandomNumberEngineFactory::getInstance().getPrototype().getParameterSet();
  // set each parameter (that is not -1);
  {
    std::stringstream input(params.parameters);
    RandomNumberEngine_Parameters *currentparameters =
        RandomNumberEngineFactory::getInstance().getPrototype().getParameterSet();
    input >> *currentparameters;  // add new values on top
    if (!currentparameters->isDefault()) {
      DoLog(1) && (Log() << Verbose(1) << "Changing prototype's parameters." << std::endl);
      RandomNumberEngineFactory::getInstance().manipulatePrototype(*currentparameters);
    }
    delete currentparameters;
  }

  {
    RandomNumberEngine_Parameters *currentparameters =
        RandomNumberEngineFactory::getInstance().getPrototype().getParameterSet();
    DoLog(1) && (Log() << Verbose(1) << "Its parameters are: " << *currentparameters << std::endl);
    delete  currentparameters;
  }

  std::stringstream output;
  output << *oldparameters;
  CommandSetRandomNumbersEngineState *newstate =
      new CommandSetRandomNumbersEngineState(oldtype,output.str(),params);
  delete oldparameters;
  return Action::state_ptr(newstate);
}

Action::state_ptr CommandSetRandomNumbersEngineAction::performUndo(Action::state_ptr _state) {
  CommandSetRandomNumbersEngineState *state =
      assert_cast<CommandSetRandomNumbersEngineState*>(_state.get());

  // note down old type for redo
  std::string newtype = RandomNumberEngineFactory::getInstance().getCurrentTypeName();
  DoLog(1) && (Log() << Verbose(1) << "Newly set engine was " << newtype << std::endl);

  // note down old parameters for redo
  RandomNumberEngine_Parameters *newparameters =
      RandomNumberEngineFactory::getInstance().getPrototype().getParameterSet();

  // set the new default
  RandomNumberEngineFactory::getInstance().setCurrentType(state->old_engine_type);
  DoLog(0) && (Log() << Verbose(0) << "Engine of random number generator is again: "
      << RandomNumberEngineFactory::getInstance().getCurrentTypeName() << std::endl);

  // set each parameter back (that is not -1);
  {
    std::stringstream input(state->old_parameters);
    RandomNumberEngine_Parameters *currentparameters =
        RandomNumberEngineFactory::getInstance().getPrototype().getParameterSet();
    input >> *currentparameters;
    if (!currentparameters->isDefault()) {
      DoLog(1) && (Log() << Verbose(1) << "Changing prototype's parameters." << std::endl);
      RandomNumberEngineFactory::getInstance().manipulatePrototype(*currentparameters);
    }
    delete currentparameters;
  }

  {
    RandomNumberEngine_Parameters *currentparameters =
        RandomNumberEngineFactory::getInstance().getPrototype().getParameterSet();
    DoLog(1) && (Log() << Verbose(1) << "Its parameters are: " << *currentparameters << std::endl);
    delete  currentparameters;
  }

  std::stringstream output;
  output << *newparameters;
  CommandSetRandomNumbersEngineState *newstate =
      new CommandSetRandomNumbersEngineState(newtype,output.str(),params);
  delete newparameters;
  return Action::state_ptr(newstate);
}

Action::state_ptr CommandSetRandomNumbersEngineAction::performRedo(Action::state_ptr _state){
  return performUndo(_state);
}

bool CommandSetRandomNumbersEngineAction::canUndo() {
  return true;
}

bool CommandSetRandomNumbersEngineAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
