/*
 * QtHomologyList.hpp
 *
 *  Created on: Jun 24, 2013
 *      Author: heber
 */

#ifndef QTHOMOLOGYLIST_H_
#define QTHOMOLOGYLIST_H_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <QtGui/QTreeWidget>
#include "CodePatterns/Observer/Observer.hpp"

class HomologyGraph;

class QtHomologyList: public QTreeWidget, public Observer
{
  Q_OBJECT

public:
  QtHomologyList(QWidget * _parent=0);
  virtual ~QtHomologyList();

protected:
  virtual void update(Observable *publisher);
  virtual void subjectKilled(Observable *publisher);
  virtual void paintEvent(QPaintEvent * event);
  void refill();

  static const int COLUMNCOUNT;
  enum {NUMBER,NODES,EDGES,OCCURRENCE,COLUMNTYPES_MAX} COLUMNTYPES;
  static const char *COLUMNNAMES[];

private slots:
  void rowSelected();

signals:
  void HomologySelected(HomologyGraph const *);
  void HomologyUnSelected(HomologyGraph const *);
  void changed();

private:
  std::vector<bool> HomologySelection; //!< needed to determine when a selection changes
  //!> flag to indicate that we got an update
  bool dirty;
  //!> flag to indicate that we currently clear the view, avoids thread collisions
  bool clearing;
};

#endif /* QTHOMOLOGYLIST_H_ */
