/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * StringQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qlabel.h>
#include <Qt/qlineedit.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Pipe/StringQtQueryPipe.hpp"


QtDialog::StringQtQuery::StringQtQuery(std::string _title,QBoxLayout *_parent,QtDialog *_dialog) :
    Dialog::StringQuery(_title),
    parent(_parent)
{
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  inputBox = new QLineEdit();
  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(inputBox);

  pipe = new StringQtQueryPipe(&tmp,_dialog);
  pipe->update(inputBox->text());
  connect(inputBox,SIGNAL(textChanged(const QString&)),pipe,SLOT(update(const QString&)));
}

QtDialog::StringQtQuery::~StringQtQuery()
{
  delete pipe;
}

// All values besides the empty std::string are valid
bool QtDialog::StringQtQuery::handle()
{
  return tmp!="";
}

