/*
 * FourBodyPotential_Improper.hpp
 *
 *  Created on: Jul 10, 2013
 *      Author: heber
 */

#ifndef FOURBODYPOTENTIAL_IMPROPER_HPP_
#define FOURBODYPOTENTIAL_IMPROPER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "FourBodyPotential_Torsion.hpp"

class FourBodyPotential_ImproperTest;
class PotentialFactory;

/** The improper potential is identical to the torsion potential with exception
 * of the way the angle is calculated.
 *
 * Hence, we only need to override function_theta().
 *
 */
class FourBodyPotential_Improper : public FourBodyPotential_Torsion
{
  //!> grant unit test access to internal parts
  friend class FourBodyPotential_ImproperTest;
  //!> grant PotentialFactory access to default cstor
  friend class PotentialFactory;
  // some repeated typedefs to avoid ambiguities
  typedef FunctionModel::result_t result_t;
  typedef FunctionModel::results_t results_t;
private:
  /** Private default constructor.
   *
   * This prevents creation of potential without set ParticleTypes_t.
   *
   * \note PotentialFactory may use this default cstor
   *
   */
  FourBodyPotential_Improper();

  /** Returns the functor that converts argument_s into the
   * internal coordinate described by this potential function.
   *
   * \return coordinator functor
   */
  Coordinator::ptr getCoordinator() const
  { return coordinator; }

public:
  FourBodyPotential_Improper(const ParticleTypes_t &_ParticleTypes);
  FourBodyPotential_Improper(
      const ParticleTypes_t &_ParticleTypes,
      const double _spring_constant,
      const double _equilibrium_distance);
  virtual ~FourBodyPotential_Improper() {}

  /** Getter for the graph specifying the binding model of the potential.
   *
   * \return BindingModel ref of the binding model
   */
  const BindingModel& getBindingModel() const
  { return bindingmodel; }

  /**
   * Returns the number of particle types associated with the potential.
   *
   * \return number of particle types
   */
  unsigned int getParticleTypeNumber() const
  { return 4; }

private:

  /** Return the token name of this specific potential.
   *
   *  We need to override the function in order to use a different static variable.
   *
   * \return token name of the potential
   */
  const std::string& getToken() const
  { return improper_token; }

private:
  //!> static definitions of the parameter name for this potential
  static const ParameterNames_t ParameterNames;

  //!> static token of this potential type
  static const std::string improper_token;

  //!> internal coordinator object for converting arguments_t
  static Coordinator::ptr coordinator;

  //!> binding model for this potential
  const BindingModel bindingmodel;
};

#endif /* FOURBODYPOTENTIAL_IMPROPER_HPP_ */
