/*
 * EmpiricalPotential.hpp
 *
 *  Created on: Sep 26, 2012
 *      Author: heber
 */

#ifndef EMPIRICALPOTENTIAL_HPP_
#define EMPIRICALPOTENTIAL_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vector>

#include "FunctionApproximation/FunctionArgument.hpp"
#include "FunctionApproximation/FunctionModel.hpp"
#include "Potentials/BindingModel.hpp"
#include "Potentials/SerializablePotential.hpp"
#include "Potentials/InternalCoordinates/Coordinator.hpp"

/** An EmpiricalPotential is a function that is given a vector of objects as
 * arguments which it uses to evaluate an internal function and returns a
 * value representing the energy of this configuration indicated by the
 * arguments.
 *
 * It is to be used inside an std::accumulate function after a vector of
 * arguments (i.e. a vector of a vector) has been prepared initially.
 *
 */
class EmpiricalPotential :
    public FunctionModel,
    public SerializablePotential
{
public:
  //!> typedef for the argument vector as input to the function
  typedef std::vector<argument_t> arguments_t;
  //!> typedef for a single result degree of freedom
  typedef double result_t;
  //!> typedef for the result vector as returned by the function
  typedef std::vector<result_t> results_t;
  //!> typedef for the components of the derivative
  typedef std::vector<result_t> derivative_components_t;

  /** Default constructor for class EmpiricalPotential.
   *
   */
  EmpiricalPotential(const ParticleTypes_t &_ParticleTypes) :
    SerializablePotential(_ParticleTypes)
  {}

  /** Destructor for class EmpiricalPotential.
   *
   */
  virtual ~EmpiricalPotential() {}

  /** Evaluates the function with the given \a arguments and the current set of
   * parameters.
   *
   * \param listarguments list of sets of arguments as input variables to the function
   * \return result of the function
   */
  virtual results_t operator()(const list_of_arguments_t &listarguments) const=0;

  /** Evaluates the derivative of the function with the given \a arguments
   * for each component.
   *
   * \param listarguments list of sets of arguments as input variables to the function
   * \return result vector containing the derivative with respect to each
   *         input comonent of the function
   */
  virtual derivative_components_t derivative(const list_of_arguments_t &listarguments) const=0;

  /** Returns the functor that converts argument_s into the
   * internal coordinate described by this potential function.
   *
   * \return coordinator functor
   */
  virtual Coordinator::ptr getCoordinator() const=0;

  /** Getter for the graph specifying the binding model of the potential.
   *
   * \return BindingModel ref of the binding model
   */
  virtual const BindingModel& getBindingModel() const=0;

  /**
   * Returns the number of particle types associated with the potential.
   *
   * \return number of particle types
   */
  virtual unsigned int getParticleTypeNumber() const=0;

protected:
  /** Default constructor for class EmpiricalPotential.
   *
   * Callable only by derived functions.
   *
   */
  EmpiricalPotential()
  {}
};

#endif /* EMPIRICALPOTENTIAL_HPP_ */
