/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * RandomNumberDistributionFactory.cpp
 *
 *  Created on: Jan 03, 2011
   Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include <utility>
#include "CodePatterns/Singleton_impl.hpp"
#include "CodePatterns/Assert.hpp"

#include <boost/random/bernoulli_distribution.hpp>
#include <boost/random/binomial_distribution.hpp>
#include <boost/random/cauchy_distribution.hpp>
#include <boost/random/exponential_distribution.hpp>
#include <boost/random/gamma_distribution.hpp>
#include <boost/random/geometric_distribution.hpp>
#include <boost/random/linear_congruential.hpp>
#include <boost/random/lognormal_distribution.hpp>
#include <boost/random/normal_distribution.hpp>
#include <boost/random/poisson_distribution.hpp>
#include <boost/random/triangle_distribution.hpp>
#include <boost/random/uniform_01.hpp>
#include <boost/random/uniform_int.hpp>
#include <boost/random/uniform_on_sphere.hpp>
#include <boost/random/uniform_real.hpp>
#include <boost/random/uniform_smallint.hpp>

#include "RandomNumberDistribution_Encapsulation.hpp"
#include "RandomNumberDistribution_Parameters.hpp"

#include "RandomNumberDistributionFactory.hpp"

// has to be included BEFORE PrototypeFactory_impl.hpp!
#include "RandomNumberDistributionFactory.def"
#include "CodePatterns/ManipulablePrototypeFactory_impl.hpp"

RandomNumberDistributionFactory::RandomNumberDistributionFactory()
{
  FillPrototypeTable();
}

RandomNumberDistributionFactory::~RandomNumberDistributionFactory()
{
  EmptyPrototypeTable();
}

CONSTRUCT_SINGLETON(RandomNumberDistributionFactory)
CONSTRUCT_MANIPULABLEPROTOTYPEFACTORY(RandomNumberDistribution, RandomNumberDistribution_Parameters)

#include "RandomNumberDistributionFactory.undef"

