/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * LinkedCell_Model_LinkedCellArrayCache.cpp
 *
 *  Created on: Dec 20, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include <boost/bind.hpp>
#include <string>

#include "LinkedCell_Model_LinkedCellArrayCache.hpp"
#include "LinkedCell_Model_changeModel.hpp"

/** Constructor for class LinkedCellArrayCache.
 *
 */
LinkedCell::LinkedCell_Model::LinkedCellArrayCache::LinkedCellArrayCache(
    Observable *_observable,
    boost::function<void ()> _updatefunction,
    const std::string _name) :
    updatefunction(_updatefunction),
    UpToDate(_observable, boost::bind(&LinkedCellArrayCache::updateMe, this), _name)
{}

/** Destructor for class LinkedCellArrayCache.
 *
 */
LinkedCell::LinkedCell_Model::LinkedCellArrayCache::~LinkedCellArrayCache()
{}

/** Getter for read operations.
 *
 * Here, we check whether the LinkedCellArray is up-to-date.
 *
 * @return const reference to LinkedCellArray
 */
const LinkedCell::LinkedCellArray &LinkedCell::LinkedCell_Model::LinkedCellArrayCache::getN() const
{
  if (*UpToDate) {
    // just a pseudo if to make sure the update function gets called.
  }
  return N;
}

/** Getter for write operations.
 *
 * This is only accessible for LinkedCell_Model and its update operations.
 *
 * @return reference to LinkedCellArray.
 */
LinkedCell::LinkedCellArray &LinkedCell::LinkedCell_Model::LinkedCellArrayCache::setN()
{
  return N;
}
