/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FastParsingAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "config.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "Actions/CommandAction/FastParsingAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "FastParsingAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr CommandFastParsingAction::performCall() {
  config *configuration = World::getInstance().getConfig();
  bool oldvalue = configuration->FastParsing;

  // obtain information
  getParametersfromValueStorage();

  configuration->FastParsing = params.fastparsing;
  if (configuration->FastParsing)
    LOG(0, "I won't parse trajectories.");
  else
    LOG(0, "I will parse trajectories.");
  return Action::state_ptr(new CommandFastParsingState(oldvalue, params));
}

Action::state_ptr CommandFastParsingAction::performUndo(Action::state_ptr _state) {
  CommandFastParsingState *state = assert_cast<CommandFastParsingState*>(_state.get());

  config *configuration = World::getInstance().getConfig();
  configuration->FastParsing = state->oldvalue;
  if (configuration->FastParsing)
    LOG(0, "I won't parse trajectories.");
  else
    LOG(0, "I will parse trajectories.");

  return Action::state_ptr(_state);
}

Action::state_ptr CommandFastParsingAction::performRedo(Action::state_ptr _state){
  CommandFastParsingState *state = assert_cast<CommandFastParsingState*>(_state.get());

  config *configuration = World::getInstance().getConfig();
  configuration->FastParsing = state->params.fastparsing;
  if (configuration->FastParsing)
    LOG(0, "I won't parse trajectories.");
  else
    LOG(0, "I will parse trajectories.");

  return Action::state_ptr(_state);
}

bool CommandFastParsingAction::canUndo() {
  return true;
}

bool CommandFastParsingAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
