/*
 * bondgraph.hpp
 *
 *  Created on: Oct 29, 2009
 *      Author: heber
 */

#ifndef BONDGRAPH_HPP_
#define BONDGRAPH_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>

/*********************************************** defines ***********************************/

#define BONDTHRESHOLD 0.4   //!< CSD threshold in bond check which is the width of the interval whose center is the sum of the covalent radii

/****************************************** forward declarations *****************************/

class molecule;
class periodentafel;
class MatrixContainer;

/********************************************** definitions *********************************/

/********************************************** declarations *******************************/


class BondGraph {
public:
  BondGraph(bool IsA);
  ~BondGraph();
  bool LoadBondLengthTable(const string &filename);
  bool ConstructBondGraph(molecule * const mol);
  double GetBondLength(int firstelement, int secondelement);
  double SetMaxDistanceToMaxOfCovalentRadii(const molecule * const mol);

  void BondLengthMatrixMinMaxDistance(BondedParticle * const Walker, BondedParticle * const OtherWalker, double &MinDistance, double &MaxDistance, bool IsAngstroem);
  void CovalentMinMaxDistance(BondedParticle * const Walker, BondedParticle * const OtherWalker, double &MinDistance, double &MaxDistance, bool IsAngstroem);

private:
  MatrixContainer *BondLengthMatrix;
  double max_distance;
  bool IsAngstroem;
};

#endif /* BONDGRAPH_HPP_ */
