/*
 * analysis_bonds.hpp
 *
 *  Created on: Nov 7, 2009
 *      Author: heber
 */

#ifndef ANALYSIS_BONDS_HPP_
#define ANALYSIS_BONDS_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*********************************************** defines ***********************************/

#define HBRIDGEDISTANCE 3.5   //!< HBridge distance from PCCP Vol 10. 4802-4813

/****************************************** forward declarations *****************************/

class element;
class MoleculeListClass;
class molecule;

/********************************************** declarations *******************************/

void GetMaxMinMeanBondCount(const molecule * const mol, double &Min, double &Mean, double &Max);
void MinMeanMaxBondDistanceBetweenElements(const molecule *mol, element *type1, element *type2, double &Min, double &Mean, double &Max);

int CountHydrogenBridgeBonds(MoleculeListClass * const molecules, element * InterfaceElement);
int CountBondsOfTwo(MoleculeListClass * const molecules, const element * const first, const element * const second);
int CountBondsOfThree(MoleculeListClass * const molecules, const element * const first, const element * const second, const element * const third);

#endif /* ANALYSIS_BONDS_HPP_ */
