/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C) 2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * FilesTextQuery.cpp
 *
 *  Created on: May 21, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include <iostream>
#include <string>

#include <boost/filesystem.hpp>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"


TextDialog::FilesTextQuery::FilesTextQuery(Parameter<std::vector< boost::filesystem::path> > &_param, const std::string &_title, const std::string &_description) :
    Dialog::TQuery<std::vector<boost::filesystem::path> >(_param, _title,_description)
{}

TextDialog::FilesTextQuery::~FilesTextQuery() {}

void TextDialog::FilesTextQuery::handle() {
  bool badInput = false;
  bool continueflag = true;
  do {
    std::string tempstring;
    do{
      badInput = false;
      std::cout << getDescription() << ": ";
      std::cin >> tempstring;
      if(std::cin.fail()){
        badInput = true;
        std::cin.clear();
        std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
        std::cout << "Input was not a valid file!" << std::endl;
        continue;
      }
    } while(badInput);
    boost::filesystem::path tempfile;
    tempfile = tempstring;
    std::cout << "Enter another file [y/n]? ";
    std::cin >> tempstring;
    if (tempstring != "y")
      continueflag = false;
    temp.push_back(tempfile);
  } while(continueflag);
  std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
  handleSuccess = true;
}

