/*
 * TextStatusIndicator.hpp
 *
 *  Created on: Feb 18, 2010
 *      Author: crueger
 */

#ifndef TEXTSTATUSINDICATOR_HPP_
#define TEXTSTATUSINDICATOR_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "CodePatterns/Observer/Observer.hpp"

namespace MoleCuilder {
  class ActionStatusList;
}


class TextStatusIndicator : public Observer
{
public:
  TextStatusIndicator();
  virtual ~TextStatusIndicator();

  void update(Observable *subject);
  void subjectKilled(Observable *subject);
  void recieveNotification(Observable *_publisher, Notification *_notification);

private:
  void displayStatusMessage() const;

private:
  //!> reference to the StatusList we are signed on
  MoleCuilder::ActionStatusList& StatusList;
  //!> indicates whether we are currently signed on
  bool StatusList_signedOn;
};

#endif /* TEXTSTATUSINDICATOR_HPP_ */
