/*
 * BoxVectorValidator.hpp
 *
 *  Created on: May 10, 2012
 *      Author: heber
 */

#ifndef BOXVECTORVALIDATOR_HPP_
#define BOXVECTORVALIDATOR_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "LinearAlgebra/Vector.hpp"

#include "Parameters/Validators/Validator.hpp"

/** This validator checks whether the given Vector is within the current
 * simulation domain, i.e. the Box.
 */
class BoxVectorValidator : public Validator< Vector >
{
  bool isValid(const Vector & Vector) const;
  bool operator==(const Validator<Vector> &_instance) const;
  Validator< Vector >* clone() const;
};


#endif /* BOXVECTORVALIDATOR_HPP_ */
