/*
 * molecule_pointcloud.cpp
 *
 *  Created on: Oct 5, 2009
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "atom.hpp"
#include "config.hpp"
#include "info.hpp"
#include "molecule.hpp"

/************************************* Functions for class molecule *********************************/

/** Returns a name for this point cloud, here the molecule's name.
 * \return name of point cloud
 */
const char * const molecule::GetName() const
{
  return name;
};

/** Determine center of all atoms.
 * \param *out output stream for debugging
 * \return pointer to allocated with central coordinates
 */
Vector *molecule::GetCenter() const
{
  Vector *center = DetermineCenterOfAll();
  return center;
};


/** PointCloud implementation of GoPoint
 * Uses atoms and STL stuff.
 */
TesselPoint* molecule::GetPoint() const
{
  return (*InternalPointer);
};

/** PointCloud implementation of GoToNext.
 * Uses atoms and STL stuff.
 */
void molecule::GoToNext() const
{
  if (InternalPointer != atoms.end())
    InternalPointer++;
};

/** PointCloud implementation of GoToFirst.
 * Uses atoms and STL stuff.
 */
void molecule::GoToFirst() const
{
  // evil hack necessary because
  // -# although InternalPointer is mutable
  // -# only const_iterator begin() is called due to const in the function declaration above
  // -# and there is no cast from const_iterator to const iterator
  atomSet::const_iterator test = begin();
  InternalPointer = *(reinterpret_cast<atomSet::iterator *>(&test));
};

/** PointCloud implementation of IsEmpty.
 * Uses atoms and STL stuff.
 */
bool molecule::IsEmpty() const
{
  return (empty());
};

/** PointCloud implementation of IsLast.
 * Uses atoms and STL stuff.
 */
bool molecule::IsEnd() const
{
  return (InternalPointer == atoms.end());
};

int molecule::GetMaxId() const {
  return getAtomCount();
}
