/*
 * CheckAgainstAdjacencyFile.hpp
 *
 *  Created on: Mar 3, 2011
 *      Author: heber
 */

#ifndef CHECKAGAINSTADJACENCYFILE_HPP_
#define CHECKAGAINSTADJACENCYFILE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>
#include <map>
#include <set>

#include "types.hpp"
#include "World.hpp"

class atom;

class CheckAgainstAdjacencyFile
{
  //!> Unit test is granted access to internal data
  friend class CheckAgainstAdjacencyFileTest;
public:
  CheckAgainstAdjacencyFile(std::istream &File);
  ~CheckAgainstAdjacencyFile();

  bool operator()(World::AtomSet::const_iterator AtomMapBegin, World::AtomSet::const_iterator AtomMapEnd);

private:
  typedef std::set<atomId_t> KeysSet;
  typedef std::set<atomId_t> ValuesSet;
  typedef std::pair<atomId_t, atomId_t> AtomBondPair;
  typedef std::multimap< atomId_t, atomId_t > AtomBondMap;
  typedef std::pair<AtomBondMap::const_iterator, AtomBondMap::const_iterator> AtomBondRange;
  AtomBondMap InternalAtomBondMap;
  AtomBondMap ExternalAtomBondMap;
  bool status;
  int NonMatchNumber;

  KeysSet getKeys(const AtomBondRange &_range) const;
  ValuesSet getValues(const AtomBondRange&_range) const;

  void CreateInternalMap(World::AtomSet::const_iterator AtomMapBegin, World::AtomSet::const_iterator AtomMapEnd);
  bool ParseInExternalMap(std::istream &File);
  bool CompareInternalExternalMap();
};

#endif /* CHECKAGAINSTADJACENCYFILE_HPP_ */
