/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * UnsignedIntsQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qpushbutton.h>
#include <Qt/qboxlayout.h>
#include <Qt/qlistwidget.h>

//#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Query/QtQueryList.hpp"


QtDialog::UnsignedIntsQtQuery::UnsignedIntsQtQuery(Parameter<std::vector<unsigned int> > &_param, const std::string &_title, const std::string &_description,QBoxLayout *_parent,Dialog *_dialog) :
    QtQuery<std::vector<unsigned int> >(_param, _title, _description),
    QtQueryList<unsigned int>(_param, _parent, _dialog, temp)
{
  ListQuerySubDialog *subDialog = new ListQuerySubDialog(this, _title);
  subQuery = new UnsignedIntQtQuery(*subParam, _title, _description, thisVLayout, subDialog);
  subDialog->setSubQuery(subQuery);

  connect(inputList,SIGNAL(itemSelectionChanged()),this,SLOT(onElementSelected()));
  connect(addButton,SIGNAL(clicked()),this,SLOT(onAddElement()));
  connect(removeButton,SIGNAL(clicked()),this,SLOT(onRemoveElement()));
}

QtDialog::UnsignedIntsQtQuery::~UnsignedIntsQtQuery()
{
  delete(subQuery);
}

void QtDialog::UnsignedIntsQtQuery::onSubUpdate()
{
  addButton->setEnabled(subParam->isSet());
}

void QtDialog::UnsignedIntsQtQuery::onElementSelected() {
  elementSelected();
}

void QtDialog::UnsignedIntsQtQuery::onAddElement() {
  addElement();
}

void QtDialog::UnsignedIntsQtQuery::onRemoveElement() {
  removeElements();
}



