/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * atom_graphnodeinfo.cpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "atom_graphnodeinfo.hpp"

/** Constructor of class GraphNodeInfo.
 */
GraphNodeInfo::GraphNodeInfo() :
  GraphNr(-1),
  ComponentNr(0),
  LowpointNr(-1),
  SeparationVertex(false),
  IsCyclic(false),
  Ancestor(0)
{};

/** Destructor of class GraphNodeInfo.
 */
GraphNodeInfo::~GraphNodeInfo()
{
  delete[](ComponentNr);
};
