/*
 * VMGDebugGridFragmentController.hpp
 *
 *  Created on: Aug 27, 2012
 *      Author: heber
 */

#ifndef VMGDEBUGGRIDFRAGMENTCONTROLLER_HPP_
#define VMGDEBUGGRIDFRAGMENTCONTROLLER_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Fragmentation/Automation/SpecificFragmentController.hpp"

#include <map>
#include <string>
#include <vector>

#include "JobMarket/JobId.hpp"

#include "Fragmentation/SetValues/Fragment.hpp"
#include "Jobs/Grid/SamplingGrid.hpp"
#include "Jobs/MPQCData.hpp"
#include "Jobs/VMGData.hpp"

/** This class uses SpecificFragmentController with functions to add specificly
 * VMGJobs.
 */
class VMGDebugGridFragmentController : public SpecificFragmentController
{
public:
  VMGDebugGridFragmentController(boost::asio::io_service &io_service) :
    SpecificFragmentController(io_service)
  {}
  virtual ~VMGDebugGridFragmentController()
  {}

  bool createDebugJobs(
      const std::vector<SamplingGrid> &full_sampled_grid);

  // there are no results but server has empty string nonetheless
  void getResults(std::map<JobId_t, std::string> &fragmentData) {
    SpecificFragmentController::getResults<std::string>(fragmentData);
  }
};


#endif /* VMGDEBUGGRIDFRAGMENTCONTROLLER_HPP_ */
