/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * VMGDebugGridFragmentController.cpp
 *
 *  Created on: Aug 27, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// boost asio needs specific operator new
#include <boost/asio.hpp>

#include "CodePatterns/MemDebug.hpp"

#include "VMGDebugGridFragmentController.hpp"

#include "Jobs/VMGDebugGridJob.hpp"

bool VMGDebugGridFragmentController::createDebugJobs(
    const std::vector<SamplingGrid> &full_sampled_grid)
{
  std::vector<FragmentJob::ptr> jobs;

  for(std::vector<SamplingGrid>::const_iterator iter = full_sampled_grid.begin();
      iter != full_sampled_grid.end();
      ++iter) {
    const JobId_t next_id = getAvailableId();
    LOG(1, "INFO: Creating full VMGDebugGridJob with " << *iter
        << " gridpoints.");
    FragmentJob::ptr testJob(
        new VMGDebugGridJob(next_id, *iter) );
    jobs.push_back(testJob);
  }

  // then send jobs to controller
  addJobs(jobs);
  sendJobs(host, port);
  RunService("Adding VMGDebugGridJobs");

  return true;
}
