#ifndef VECTOR_HPP_
#define VECTOR_HPP_

class Vector;

/** Single vector.
 * basically, just a x[3] but with helpful functions
 */
class Vector {
  public:
    double x[NDIM];

  Vector();
  Vector(double x1, double x2, double x3);
  ~Vector();

  double Distance(const Vector *y) const;
  double DistanceSquared(const Vector *y) const;
  double PeriodicDistance(const Vector *y, const double *cell_size) const;
  double ScalarProduct(const Vector *y) const;
  double Projection(const Vector *y) const;
  double Norm() const ;
  double Angle(Vector *y) const;

  void AddVector(const Vector *y);
  void SubtractVector(const Vector *y);
  void CopyVector(const Vector *y);
  void RotateVector(const Vector *y, const double alpha);
  void VectorProduct(const Vector *y);
  void ProjectOntoPlane(const Vector *y);
  void Zero();
  void One(double one);
  void Init(double x1, double x2, double x3);
  void Normalize();
  void Translate(const Vector *x);
  void Mirror(const Vector *x);
  void Scale(double **factor);
  void Scale(double *factor);
  void Scale(double factor);
  void MatrixMultiplication(double *M);
  void InverseMatrixMultiplication(double *M);
  void KeepPeriodic(ofstream *out, double *matrix);
  void LinearCombinationOfVectors(const Vector *x1, const Vector *x2, const Vector *x3, double *factors);

  double CutsPlaneAt(Vector *A, Vector *B, Vector *C);
  bool GetOneNormalVector(const Vector *x1);
  bool MakeNormalVector(const Vector *y1);
  bool MakeNormalVector(const Vector *y1, const Vector *y2);
  bool MakeNormalVector(const Vector *x1, const Vector *x2, const Vector *x3);
  bool SolveSystem(Vector *x1, Vector *x2, Vector *y, double alpha, double beta, double c);
  bool LSQdistance(Vector **vectors, int dim);

  void AskPosition(double *cell_size, bool check);
  bool Output(ofstream *out) const;
};

ofstream& operator<<(ofstream& ost, Vector& m);
Vector& operator+=(Vector& a, const Vector& b);
Vector& operator*=(Vector& a, const double m);
Vector& operator*(const Vector& a, const double m);
Vector& operator+(const Vector& a, const Vector& b);

#endif /*VECTOR_HPP_*/
