/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * RandomNumberEngineFactory.cpp
 *
 *  Created on: Jan 03, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <utility>
#include "CodePatterns/Singleton_impl.hpp"
#include "CodePatterns/Assert.hpp"

#include <boost/nondet_random.hpp>
#include <boost/random.hpp>
#include <boost/random/additive_combine.hpp>
#include <boost/random/discard_block.hpp>
#include <boost/random/inversive_congruential.hpp>
#include <boost/random/lagged_fibonacci.hpp>
#include <boost/random/linear_congruential.hpp>
#include <boost/random/linear_feedback_shift.hpp>
#include <boost/random/mersenne_twister.hpp>
#include <boost/random/random_number_generator.hpp>
#include <boost/random/ranlux.hpp>
#include <boost/random/shuffle_output.hpp>
#include <boost/random/subtract_with_carry.hpp>
#include <boost/random/xor_combine.hpp>

#include "RandomNumberEngine_Encapsulation.hpp"
#include "RandomNumberEngine_Parameters.hpp"

#include "RandomNumberEngineFactory.hpp"

// has to be included BEFORE PrototypeFactory_impl.hpp!
#include "RandomNumberEngineFactory.def"
#include "CodePatterns/ManipulablePrototypeFactory_impl.hpp"

RandomNumberEngineFactory::RandomNumberEngineFactory()
{
  FillPrototypeTable();
}

RandomNumberEngineFactory::~RandomNumberEngineFactory()
{
  EmptyPrototypeTable();
}

CONSTRUCT_SINGLETON(RandomNumberEngineFactory)
CONSTRUCT_MANIPULABLEPROTOTYPEFACTORY(RandomNumberEngine, RandomNumberEngine_Parameters)

#include "RandomNumberEngineFactory.undef"

