/*
 * writeTable.hpp
 *
 *  Created on: Aug 3, 2012
 *      Author: heber
 */

#ifndef WRITETABLE_HPP_
#define WRITETABLE_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/mpl/for_each.hpp>

#include <string>
#include <sstream>
#include <vector>

#include "Fragmentation/Summation/HeaderPrinter.hpp"
#include "Fragmentation/Summation/ValuePrinter.hpp"

/** Templated functor to write from a given vector of summed up results the
 * table with decent header line.
 *
 * @param results vector of results of MapType
 * @param MaxLevel print values up till this level
 * @return string of the resulting table
 */
template <typename MapType, typename VectorType, int numprecision=10>
struct writeTable{
  std::string operator()(const std::vector<MapType> &results, const size_t MaxLevel, const size_t StartLevel=1)
  {
    std::stringstream resultstream;

    /// create header line for energy
    resultstream << "level";
    HeaderPrinter header;
    boost::mpl::for_each<VectorType>(boost::ref(header));
    resultstream << header.get() << std::endl;

    /// print values per line
    if (MaxLevel >= StartLevel) {
      ASSERT( results.size() >= (MaxLevel-StartLevel),
          "writeTable<M,V>() - results has insufficient size.");
      for (size_t level = StartLevel; level <= MaxLevel; ++level) {
        resultstream << level;
        ValuePrinter<MapType, numprecision> values(results[level-1]);
        boost::mpl::for_each<VectorType>(boost::ref(values));
        resultstream << values.get() << std::endl;
      }
    } else {
      ELOG(2, "writeTable does not output as MaxLevel(" << MaxLevel
          << ") < StartLevel(" << StartLevel << ".");
    }
    return resultstream.str();
  }
};


#endif /* WRITETABLE_HPP_ */
