/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * VectorCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Actions/Values.hpp"
#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Box.hpp"
#include "World.hpp"

CommandLineDialog::VectorCommandLineQuery::VectorCommandLineQuery(Parameter<Vector> &_param, std::string title, std::string _description) :
    Dialog::TQuery<Vector>(_param, title, _description)
{}

CommandLineDialog::VectorCommandLineQuery::~VectorCommandLineQuery()
{}

bool CommandLineDialog::VectorCommandLineQuery::handle() {
  VectorValue _temp;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    try {
      _temp = CommandLineParser::getInstance().vm[getTitle()].as< VectorValue >();
    } catch(boost::bad_any_cast &e) {
      for (size_t i=0;i<NDIM;++i)
        _temp.vector[i] = 0.;
      return false;
    }
    temp = _temp.toVector();
    return true;
  }
  return false;
}

